// Quelle: TLpy2_52f
// Lizenzbestimmungen:
// Autoren F. Bollow, G. Krumm (LocoNet-Adaption)
// Lizenzvertrag: CC BY-NC-SA 4.0
// Kurzform: Namensnennung - Nicht-kommerziell - Weitergabe unter gleichen Bedingungen 4.0 International
// Details: creativecommons.org/licenses/by-nc-sa/4.0/legalcode.de


//#define LOCONET

#define VERSION "TXpy2_53"    
// Version TXpyOpxx: Touchscreenplatine für XBus
// Version TLpyOpxx: Touchscreenplatine für LocoNet
// Version PXpyOpxx: Fahrpultplatine für XBus
// Version PLpyOpxx: Fahrpultplatine für LocoNet


void XL_setSpeed(uint16_t, uint8_t, uint8_t);  // LokStop via STW

#ifdef LOCONET
// ------------------------------------------------------------------
#include <LocoNet.h>
#define LN_TX_PIN 6         //LocoNet-Transmit-Pin: fuer Fahrpultplatine 2, fuer Touchscreenplatine 6
#define WDELAY    false     //Verlaengerung der Schaltzeit ueber Zentrale = true
#define LNC_ADR   1         //Adresse des zu checkenden Schaltartikels
#define LNC_INT   8         //LocoNet-Check-Intervall in Zyklen von WAIT
#define HandreglerID 256
#define LNDummyAddr  10000
LocoNetThrottleClass Throttle;

TH_STATE Status;
LnBuf    LnRxBuffer;
bool     FirstSel;
uint8_t  LNCcnt  = 0;
uint8_t  RMlnt  = 0;
lnMsg    *LnPacket;
TH_ERROR Fehler; 
uint32_t LastThrottleTimerTick;
char *stbus[] = {"LN_Hold","LN_Run"};

//Fahrstufen predefined
#define Loco14  TH_SP_ST_14
//#define Loco27  0x01    
#define Loco28  TH_SP_ST_28
#define Loco128 TH_SP_ST_128

static uint8_t RMpin[16] = {22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37};
//static uint8_t RMpin[RMDIM] = {22, 23, 24, 25, 26, 27, 28, 29, 37, 36, 35, 34, 33, 32, 31, 30};
// ------------------------------------------------------------------
#else
//#include "XpressNetMaster.h"
//XpressNetMasterClass XpressNet;
#include "XpressNet.h"
XpressNetClass XpressNet;

char *stbus[] = {"XB_Hold","XB_Run"};

uint8_t XNetAddress = 9;
                            //Max485 Busdriver Send/Receive-PIN
#define XNetSRPin     5     // Fuer Touchscreenplatine
//#define XNetSRPin   13     // fuer Fahrpultplatine 
// -------------------------------------------------------------------
#endif                      

// void SetTrntPos(uint16_t Address, uint8_t state, uint8_t active); // Aenderung der Weichenlage
#define XWAIT  1100
#define XWLONG 2000
#define WAIT   1000

#define RQUEST 4            // getPowerState()

uint8_t PScnt  = RQUEST;
uint8_t LokIndex = 0;

uint8_t NewState     = 0;   // Anlagenzustand an Rasp
uint8_t NewStateFlag = 0;
uint8_t Holdstrp     = 0;

uint16_t portsAC   = 0;     // Port A und C vereinigt, RM Zustand aktuell
uint32_t RmH       = 0xFFFF;     // 16 Bit Rm 17 - 32
uint8_t  noticnt   = 0;

char Linf [20]     = {0};   // Lokinfo an Raspberry bei Änderung mit Multimaus

// -------------------------------------------------------------------------
// Übernahme aus XLStw02.ino

// -----------------------------------------------------------------
// https://www.instructables.com/two-ways-to-reset-arduino-in-software/

void (* resetFunc)(void) = 0;
// ------------------------------------------------------------------


#define RMDIM      33         // index 0 nicht verwendet


//RMITEM RMKoord[RMDIM] = {0, 0, 0, 0, 0, 0}; // struct in csvParser.h
//  x y r r B R
                        //0          5         10        15


uint8_t  RiBit         = 0x80;
uint16_t GL_Lokrequest = 0;
uint8_t  GL_LokRm      = 0;

#ifdef LOCONET
struct LOKITEM {              // jede Lok nur einmal in Liste, jede Lok einmal Lokdir
  uint16_t Lokadr;
  uint8_t  Lokdir;  
  uint8_t  Stopmode;
  uint8_t  Fugroup0;           // F0-F4
  uint8_t  Slot;
} Larray[RMDIM] = {0, 0, 0, 0, 0};
#else
struct LOKITEM{               // jede Lok nur einmal in Liste, jede Lok einmal Lokdir
  uint16_t Lokadr;
  uint8_t  Lokdir;  
  uint8_t  Stopmode;
  uint8_t  Fugroup0;           // F0-F4
} Larray[RMDIM] = {0,0,0,0};
#endif

struct {
  uint8_t Lokindex;
  uint8_t Lokstop;           // Auftrag
}RmArray[RMDIM] = {0,0};     // index ist Rm-Nummer, Array inhalt ist Indes in die Loktabelle

uint8_t  RMrel[RMDIM]  = {0};
uint32_t Vakanz        = 0;
uint32_t VakanzL       = 0;

// Test nur eine Lok, 1x Direction
uint8_t LokDirection = 0;

// ----------------------------------------------------------

#ifdef LOCONET
boolean isTime(unsigned long *timeMark, unsigned long timeInterval)
{
    unsigned long timeNow = millis();
    if ( timeNow - *timeMark >= timeInterval) {
        *timeMark = timeNow;
        return true;
    }    
    return false;
}
#endif

void CheckStop(uint8_t k) {   // k korrigiert 1-16

uint8_t  Speed   = 0;
uint8_t  Dir     = 0;
uint16_t Lok     = 0;
uint8_t  Lzeig   = RmArray[k].Lokindex;
uint8_t  Stopcmd = RmArray[k].Lokstop;

     Lok = Larray[Lzeig].Lokadr;
     if (Larray[Lzeig].Stopmode) {        
        Speed = 1;
        }     

     if (Lok != 0 && Stopcmd) {      
         Dir = Larray[Lzeig].Lokdir;
         Serial.print("1x Stop Rm,Adr,Dir: ");Serial.print(k);
         Serial.print(',');Serial.print(Lok);Serial.print(',');
         
         if (Dir)  RiBit = 0x80;
         else      RiBit = 0;
         if (RiBit) Serial.println("Vw");
         else       Serial.println("Rw");
         
         XL_setSpeed(Lok,4,Speed | RiBit);
         //RmArray[k].Lokstop = 0;          // Stop nur einmal moeglich     
         // Löschen mit V-Kommando, "Void"                                  
        }
} // CheckStop()


void TrackContacts(void) {
         byte portARM      = 0;
         byte portCRM      = 0;
         uint32_t change   = 0;
         uint32_t bitmask  = 0x00000001;
         uint32_t output   = 0;  

  // uint16_t portsAC   = 0;      // Port A und C vereinigt
  static uint16_t portsAC_L = 0;  // Belegt bei Start erkennen
  static uint32_t Dword_L   = 0;  // 32 bit last
         uint32_t Dword     = 0;  // 32 bit actuell

#ifdef LOCONET
//  if (RMlnt) {
//    LnPacket = LocoNet.receive();
//    if (LnPacket) LocoNet.processSwitchSensorMessage(LnPacket);
//  }
  updateLN();
#endif
  portARM = PINA; // Rueckmeldebits lesen
  portCRM = PINC;

  portsAC = ~((bitreverse(portCRM) << 8) + portARM);
  // nach Tilde ~: 1 belegt, 0 frei
  
  Dword = (~RmH << 16) | portsAC;    
    if (Dword != Dword_L)  {          // Veraenderungen gegenueber letzter Abfrage?
                                      // 32 bit Vergleich  
     change = Dword ^ Dword_L;        // Veraenderungen registrieren   
     Vakanz = Vakanz | Dword;         // belegt sofort
     if (VakanzL != Vakanz) {
        Serial2.println(Vakanz);
        //Serial.print('b');PrintBin(Vakanz >> 8);PrintBin(Vakanz  & 0xFF);
        }
    
     for (int k = 0; k < RMDIM; k++) { 
       if (change & bitmask) {        // gibt es Veraenderungen?         
          if  (!(Dword & bitmask)) {  // von 1 auf 0     
            RMrel[k] = 5;
            }  
         else {                       // von 0 auf 1
            if (RMrel[k] == 0) {
               CheckStop(k+1);
               }
            RMrel[k] = 0;              // evtl. laufende Zählung stop  
         }
       } // if change
       bitmask = bitmask << 1;
     } // for 
   
  } // if Veränderungen
  
  Dword_L = Dword;
  VakanzL   = Vakanz;
    
} // TrackContacts()


void Lokinfosend(void) {

if (Linf[0] != 0) {
   Serial2.println(Linf);
   Linf[0] = 0;
}
  
} // Lokinfosend()

//------------------------------------------------------------------------

uint32_t ReleaseCnt(void) {       // in loop(): millis() Timer
uint32_t  bitmask   = 0x00000001;
uint32_t  bitsout   = 0xFFFFFFFE;
uint32_t  output    = 0xFFFFFFFF;

for (int k = 0; k < RMDIM; k++) { 
    if (RMrel[k] != 0) {
       RMrel[k]--;
       if (RMrel[k] == 0) {
           output = output & bitsout;                
           }
       }
    bitmask =  bitmask << 1;
    bitsout = (bitsout << 1) | 1;     
    } // for 
    
return output;
} // ReleaseCnt()



void PrintBin(uint8_t Value) {

  for(uint8_t m = 0x80; m > 0; m = m>>1) {
    
    if (Value & m) Serial.print('1');
    else Serial.print('0');
  }
  Serial.print(' ');
}

uint8_t bitreverse(uint8_t x) { // sketch_mar19a_bitinverse.ino
  uint8_t total = 0;

  for (int n = 0; n < 8; n++) {
    total = total << 1;
    total += x & 1; // modulo operation
    x = x >> 1;
  }
  return total;
} //bitreverse()


// -------------------------------------------------------------------------
void setup() {
#ifndef LOCONET
  pinMode(XNetSRPin, OUTPUT);
  digitalWrite(XNetSRPin, LOW); // MAX485 Output: High Z
#endif

//
//==== Rueckmelder Handling: =====================================================
//     wenn fuer LocoNet Belegtmelder-Startstatus = frei   ---> RMsts = 0xFF
//                                                         ---> RmH   = 0xFFFF
//     wenn fuer LocoNet Belegtmelder-Startstatus = belegt ---> RMsts = 0
//                                                         ---> RmH auf 0 belassen
//================================================================================
//
#ifdef LOCONET
  //char *stbus[] = {"LN_Hold","LN_Run"};
  ///16 Bit Rueckmelder LocoNet
//uint8_t RMsts = 0xFF; RmH = 0xFFFF;
  uint8_t RMsts = 0xFF;
  DDRA  = 0xFF; // 8 Output    pin22=PA0, ..., pin29 PA7, pin25=PA3, (0x08)
  PORTA = RMsts;
  DDRC  = 0xFF; // 8 Output    pin37=PC0, ..., pin30=PC7
  PORTC = RMsts;
#else
  //char *stbus[] = {"XB_Hold","XB_Run"};
  // 16 Bit Rueckmelder
  DDRA  = 0x00;  // 8 Input    pin22=PA0, ..., pin29 PA7, pin25=PA3, (0x08)
  PORTA = 0xFF;  // 8x Pull-up
  DDRC  = 0x00;  // 8 Input    pin37=PC0, ..., pin30=PC7
  PORTC = 0xFF;  // 8x Pull-up
#endif

for (int k=0; k <= RMDIM; k++) Larray[k].Lokdir = 1;

  Serial.begin(115200);
  Serial.println(VERSION);
  #ifndef LOCONET
    Serial.print("XBus Address: ");Serial.println(XNetAddress);
  #endif
  Serial.print("XWAIT:");Serial.println(XWAIT);
  Serial2.begin(9600);
  Serial2.println("Start Ard.");

#ifdef LOCONET
  LocoNet.init(LN_TX_PIN);                //Initialisierung LocoNet
  Throttle.init(64, 0, HandreglerID);
  FirstSel = true;
  updateLN(); updateLN();
  //Serial.print(F("====> INIT: Status  = ")); Serial.println(Throttle.getStateStr(Throttle.getState()));
  //Serial.print(F("            Slot    = ")); Serial.println(Throttle.getSlot());
  //Serial.print(F("            SlotAdr = ")); Serial.println(Throttle.getAddress());
#else
// XpressNet.setup(Loco128, XNetSRPin);    //Initialisierung XNet-Bus
XpressNet.start(XNetAddress, XNetSRPin);    //Initialisierung XNet-Bus
#endif

Serial3.begin(38400);
Serial3.println("Waiting for Rm");

} // setup()
// -------------------------------------------------------------------------


int  i = 0;       // Serial FTDI
char y;

int j = 0;        // Serial RmH UNO
char z;

#define ADIM 80
char marray[ADIM] = "";
char sarray[ADIM] = "";
char rarray[ADIM] = "";

#define FDIM   20
int16_t Fweg[FDIM] = {0};
#define DEFDIM 10

unsigned long aktuellZeit = 0;
unsigned long davorZeit   = 0;


unsigned long aktuellXZeit = 0;
unsigned long davorXZeit   = 0;

unsigned long StartTime = 0;
unsigned long StopTime  = 0;
unsigned long DiffTime  = 0;

#define GRD_GRN  1
#define RND_ROT  0

uint16_t Wnum  = 8;
uint8_t  WLage = RND_ROT;

int cnt  = 0;
int cnti = 0;
int xcnt = 0;
int anzW = 0;

#define  XQDIM 256
int16_t  XBusQueue[XQDIM] = {0};
uint16_t WRptr            =  0;
uint16_t RDptr            =  0;
#define  PTRMSK            XQDIM-1  // 64 Bytes, Maske 0x3F

int16_t QWnum = 0;

int16_t num = 0;

char *stra[] = {"Msg. 0","Msg. 1","Msg. 2","Msg. 3"};  // 7 Zeichen
char *strb[] = {"_0Pwr ok","_1Nothalt","_2Notaus","_3other"};

uint8_t  FuByte0      = 0;    // Funktionsbits F0 - F4

//------------------------------------------------------

uint8_t SearchLokRi(uint16_t slok) {
uint8_t RiBit = 0xFF;
for (int i = 1; i <= RMDIM; i++) {    
    if (i == RMDIM) return RiBit;       // Liste voll
    if (Larray[i].Lokadr == slok) {         
        RiBit = Larray[i].Lokdir;
        } 
    }
return RiBit;
}

uint8_t SearchLok(uint16_t slok) {

for (int i = 1; i <= RMDIM; i++) {
    if (i == RMDIM) return 0;           // Liste voll
    if (Larray[i].Lokadr == 0) {
        Larray[i].Lokadr = slok;        // neue Lok
        RiBit = Larray[i].Lokdir;         
        if (RiBit) RiBit = 0x80;
        XL_setSpeed(slok, 4,0 | RiBit);
        FuByte0 = Larray[i].Fugroup0;   // F0-F4
        XL_setFunc0to4(slok, FuByte0); 
        //XL_getLocoInfo(slok);     // kein Notify, unklar
        return i;
    }
    else {
        if (Larray[i].Lokadr == slok) { // Lok in Liste
#ifdef LOCONET
           Serial.println(F("---> Vorhandene Lok"));
           //Fehler = Throttle.resumeAddress(Larray[i].Lokadr, Larray[i].Slot);
#endif
           return i;
           }    
    }
}
return 0;
} // SearchLok()


uint8_t CntLok(uint16_t slok) {

for (int i = 1; i <= RMDIM; i++) {
    if (Larray[i].Lokadr == slok) {
       return i;
      }
   }
return 0;   
} // CntLok()

//------------------------------------------------------

int      parserB(char *stri) {      // Bremsauftrag Lokstop sofort oder mit Auslauf
int      slen         = strlen(stri);
int      cnt          = 0;
int      j            = 0;
char     tstr[DEFDIM] = {""};
int      val          = 0;

int      param[3]     = {0};

uint8_t Stopmode      = 0;  

if (stri[0] == 'b') Stopmode = 1;
else                Stopmode = 0;

for (int i = 1; i < slen; i++) { // skip 'B','b'
  Serial.print(stri[i]);

  if (stri[i] == ',') { 
      tstr[j] = '\0';
      j = 0;
      val = atoi(tstr);     
      param[cnt] = val;
      cnt++;
      } // if 
  else {
    tstr[j] = stri[i];   // Teilstring aufbauen
    j++;
    }  
} // for

uint8_t Lokzeig = SearchLok(param[1]); LokIndex = Lokzeig;
Larray[Lokzeig].Stopmode = Stopmode;
RmArray[param[0]].Lokstop = 1;

RmArray[param[0]].Lokindex = Lokzeig;

GL_Lokrequest = param[1];
GL_LokRm      = param[0];
//XL_getLocoInfo(GL_Lokrequest);        // bei Lokstart         // nur Direction interessant

Serial.print("prepare Para 0,1 Rm Lok: ");Serial.print(param[0]);
Serial.print(", ");Serial.print(param[1]);Serial.print(" ");
RiBit = Larray[Lokzeig].Lokdir; 
if (RiBit) Serial.print(" Vw ");
else       Serial.print(" Rw ");   
} // parserB()

//------------------------------------------------------

int      parserL(char *stri) {                // Lokstart, Dir, Horn, Speed
int      slen         = strlen(stri);
int      cnt          = 0;
int      j            = 0;
char     tstr[DEFDIM] = {""};
int      param[3]     = {0};
int      val          = 0;
uint8_t  RiBit        = 0;
uint16_t Lok          = 0;
uint8_t  Lzeig        = 0;
uint8_t  Speed        = 0;
uint8_t  StartSpeed   = 0;                    // setting by 'L'
uint8_t  fuBit        = 0;
uint8_t  fuMsk        = 0;

uint8_t  FuArray[]    = {0x10,0x01,0x02,0x04,0x08};
         // index         0    1    2    3    4

for (int i = 1; i < slen; i++) { // skip 'L','D'

  if (stri[i] == ',') { 
      tstr[j] = '\0';
      j = 0;
      val = atoi(tstr);   
      param[cnt] = val;
      cnt++;       
      } // if 
  else {
    tstr[j] = stri[i];   // Teilstring aufbauen
    j++;
    }  
} // for

Serial.print("stri:");Serial.print(stri);
Serial.print('_');Serial.print(param[0]);
Serial.print('_');Serial.print(param[1]);
Serial.print('_');Serial.println(param[2]);

switch(stri[0]) {
  
case 'V':             // void, Lokstop löschen
      Serial.print("Stop void Rm,Lok: ");Serial.print(param[0]);
      RmArray[param[0]].Lokstop = 0;
      Lzeig = RmArray[param[0]].Lokindex;
      Lok   = Larray[Lzeig].Lokadr;
      Serial.print(", ");Serial.print(Lok);
      break;

case 'l':             // kleines L, Lok Stop sofort
      Serial.print("Stop Rm,Lok: ");Serial.print(param[0]);
      Lzeig = RmArray[param[0]].Lokindex;
      Lok   = Larray[Lzeig].Lokadr;
      Serial.print(", ");Serial.print(Lok);
      Serial.print(", ");
      RiBit = Larray[Lzeig].Lokdir;
      if (RiBit) Serial.print("Vw ");
      else       Serial.print("Rw ");   
      if (RiBit) RiBit = 0x80;
      XL_setSpeed(Lok,4,0 | RiBit);
      break;  

case 'L':             // Lok Start
      //XL_getLocoInfo(GL_Lokrequest);        // bei Lokstart 
      Serial.print("Start Rm,Lok,Ri,Speed: ");Serial.print(param[0]);
      Lzeig = RmArray[param[0]].Lokindex;
      Lok   = Larray[Lzeig].Lokadr;
      StartSpeed = param[2];
      
      Serial.print(", ");Serial.print(Lok);
      Serial.print(", ");
      RiBit = Larray[Lzeig].Lokdir;
      if (RiBit) Serial.print("Vw ");
      else       Serial.print("Rw ");  
      Serial.print(", ");Serial.print(StartSpeed); 
      if (RiBit) RiBit = 0x80;
      XL_setSpeed(Lok,4,StartSpeed | RiBit);  // Speed
      
     break;

case 'G':         // Speed ohne Rm, Bypass
      Serial.print("Speed bypass: Lok,Speed: ");Serial.print(param[1]);
      Serial.print(',');Serial.print(param[2]);Serial.print(' ');
      RiBit = SearchLokRi(param[1]);
      if (RiBit == 0xFF) {
         Serial.print("Lok nicht gefunden");
         }
      else {
         if (RiBit) RiBit = 0x80;
         XL_setSpeed(param[1],4,param[2] | RiBit);
         }      
      break;
      
case 'D':           // Lok Richtung aendern und Stop
      Serial.print("Dir Rm,Lok:");Serial.print(param[0]); 
      Lzeig = RmArray[param[0]].Lokindex;
      Lok   = Larray[Lzeig].Lokadr;
      Serial.print(", ");Serial.print(Lok);
      RiBit = Larray[Lzeig].Lokdir;
      if (RiBit)     Larray[Lzeig].Lokdir = 0;
      else           Larray[Lzeig].Lokdir = 1;
      RiBit =        Larray[Lzeig].Lokdir;   
      if (RiBit) Serial.print("Vw ");
      else       Serial.print("Rw ");   
      if (RiBit) RiBit = 0x80;
      XL_setSpeed(Lok,4,0 | RiBit);   
      //XL_getLocoInfo(GL_Lokrequest);       // Versuch             
     break;


case 'F':                     // Funktionen F0-F4       // Funk. müssen lokspezifisch sein tbd
     Serial.print("F-Rm,Lok:");Serial.print(param[0]); 
     Lzeig = RmArray[param[0]].Lokindex;
     Lok   = Larray[Lzeig].Lokadr;
     Serial.print(',');Serial.println(Lok);
     fuBit = FuArray[param[2]];      
     FuByte0 = Larray[Lzeig].Fugroup0;
     FuByte0 = FuByte0 | fuBit;          // Bit set only
     Larray[Lzeig].Fugroup0 = FuByte0;
     XL_setFunc0to4(Lok,FuByte0);        // F0 - F4
     Serial.print("FuByte0 :");Serial.println(FuByte0,HEX);
    break;
    

case 'f':                   // Toggle Function F0-F4  Horn ist lokspezifisch, von py aus LocoFV.txt
     Serial.print("f-Rm,Lok,func:");Serial.print(param[0]); 
     Lzeig = RmArray[param[0]].Lokindex;
     Lok   = Larray[Lzeig].Lokadr;
     Serial.print(',');Serial.print(Lok);
     Serial.print(',');Serial.print(param[2]);
     // Wert Bilden aus FuArray[]
     fuBit = FuArray[param[2]];
     fuMsk = ~fuBit;  
     FuByte0 = Larray[Lzeig].Fugroup0;
        
     if (FuByte0 & fuBit) {  // bit ist 1
         FuByte0 = FuByte0 & fuMsk;     // toggle jetzt 0  
         Larray[Lzeig].Fugroup0 = FuByte0;       
        }
     else {                  // bit ist 0
         FuByte0 = FuByte0 | fuBit;     // toggle jetzt 1  
         Larray[Lzeig].Fugroup0 = FuByte0;         
        }
     XL_setFunc0to4(Lok,FuByte0);  // Licht F0, F1, Fx
     Serial.print("FuByte0 :");Serial.println(FuByte0,HEX);
    break; 

case 'S':       // Speed
    Serial.print("Rm,Speed,Lok:");Serial.print(param[0]); 
    Lzeig = RmArray[param[0]].Lokindex;
    Lok   = Larray[Lzeig].Lokadr;
    Speed = param[1];
    Serial.print(',');Serial.print(Speed);Serial.print(',');
    Serial.println(Lok);
    RiBit = Larray[Lzeig].Lokdir;   
    if (RiBit) RiBit = 0x80;
    XL_setSpeed(Lok,4,Speed | RiBit);  // Speed
   break; 
        
default:

    break;
} // switch()

} // parserL()

//------------------------------------------------------


uint16_t RDqueue(void) {
int16_t dat = 0;

if (WRptr != RDptr) {
   dat = XBusQueue[RDptr];
   RDptr++; RDptr = RDptr & PTRMSK;
   }
//if (WRptr == 12) LQueue();
return dat;
} // RDqueue()


void WRqueue(int16_t indat){
     XBusQueue[WRptr]=indat;
     WRptr++; WRptr = WRptr & PTRMSK;     
  
} // WRqueue()


void EWeiche(int Adr) {

Serial.print(",>X:");Serial.print(Adr);
WRqueue(Adr);  
} // EWeiche()

#ifdef LOCONET
// Some turnout decoders (DS54?) can use solenoids, this code emulates the digitrax
// throttles in toggling the "power" bit to cause a pulse
void requestSwitch(int address, byte dir, byte wdelay) {
    LocoNet.requestSwitch(address, 1, dir);
    updateLN();
    if (!wdelay) LocoNet.requestSwitch(address, 0, dir);
}

void updateLN() {
  LnPacket = LocoNet.receive(); //permanent update the library
  if (LnPacket) {
    if (!LocoNet.processSwitchSensorMessage(LnPacket)) {
      Throttle.processMessage(LnPacket);
    }
  }

  if (isTime (&LastThrottleTimerTick, 100)) Throttle.process100msActions ();
  //if (Throttle.getSlot() == 255) Throttle.stealAddress(Lokactive.LAdresse);
}

// This call-back function is called from LocoNet.processSwitchSensorMessage
// for all Sensor messages
void notifySensor(uint16_t Address, uint8_t State) {
if ((Address != 0) && (Address <= 16)) digitalWrite(RMpin[Address - 1 ], !State);
else if ((Address >= 17) && (Address <= 32)) bitWrite(RmH, Address - 17, !State);

// ---- Fuer Test mit Simulation Rueckmelder IB2neo ----------------------------------
// if ((Address >= 17) && (Address <= 32)) digitalWrite(RMpin[Address - 17 ], !State);
// else if ((Address != 0) && (Address <= 16)) bitWrite(RmH, Address - 1, !State);

}
#endif

void LQueue(void) {
 for(int k=0;k<12;k++) {
  Serial.print(' ');Serial.print(XBusQueue[k]);
 }
 Serial.println(); 
}

int lastAdr = 0;
int XWvar   = 0;
int delcnt  = 0;

void XBout(int QWnum) {
if (QWnum) {
          if (QWnum < 0) {
              QWnum= abs(QWnum);
              WLage = RND_ROT;
              }
          else {
              WLage = GRD_GRN;
              }
#ifdef LOCONET
      requestSwitch(QWnum, WLage, WDELAY);
#else

// Client-Version
XpressNet.setTrntPos((QWnum-1) >> 8, (QWnum-1) & 0x00FF,WLage | 0x08);

#endif
      StopTime = millis();  
      DiffTime = StopTime - StartTime;
      Serial.print(' ');Serial.println(DiffTime);
      lastAdr=QWnum;
      }
} // XBout()

// -----------------------------------------------------------

#define stay 0
#define run  1

bool XBcheck(void) {
static uint8_t lastcnt = 0;
static uint8_t state   = 0;
bool output = false;

#ifdef LOCONET
if (!LNCcnt) {
  if (LocoNet.reportSwitch(LNC_ADR) == LN_RETRY_ERROR) noticnt++;
  else                                                 lastcnt = noticnt;
  }
LNCcnt++; if (LNCcnt == LNC_INT) LNCcnt = 0;
#endif

if (lastcnt != noticnt)  {
   if (state == run) {
      Serial.println(stbus[0]);
      Serial2.println(stbus[0]);
      state = stay;
      output = true;
      }
   }
else {
  if (state == stay) {
    Serial.println(stbus[1]);
    Serial2.println(stbus[1]);
    state = run;
    output = true;
    }
 }
#ifndef LOCONET
lastcnt = noticnt;
#endif
return output;
} // XBcheck()


//------------------------------------------------------------
#ifndef LOCONET
void ReceiveRmH(void) {
int slen = 0;

if (Serial3.available() > 0)  {   
     z = Serial3.read();       
     rarray[j] = z;                     // char einsammeln
     j++;
     if (j > (ADIM-5)) {
         Serial.println("near overflow, j=0");
         j=0;
         }
     if (z == 0x0A) {           // LF         
        rarray[j]= '\0';         
       slen = strlen(rarray);
       rarray[slen-2] = '\0';   // remove cr/lf
       //Serial.print("size: ");Serial.print(slen);Serial.print('.');
       //Serial.print(rarray);Serial.print('.');
       RmH = atol(rarray);
       j=0;       
       Serial.println(RmH,HEX);
       }
  }
} // ReceiveRmH()
#endif

//------------------------------------------------------------
// called from loop():

void Ard2Rasp(void) {

TrackContacts();  // Update RM  

#ifndef LOCONET
ReceiveRmH();
#endif

Lokinfosend();

aktuellZeit = millis();
if (aktuellZeit - davorZeit > WAIT) { //XWLONG
   davorZeit = aktuellZeit;

   XBcheck();

   uint32_t frei = ReleaseCnt();
   
   if (frei != 0xffffffff) {
      Vakanz = Vakanz & frei;
      Serial2.println(Vakanz);
      //Serial.print('f');PrintBin(Vakanz >> 8);PrintBin(Vakanz & 0xFF);
   }
      
   if (NewStateFlag) {
      if (NewState > 2) {
          NewState = 3;
          }
      Serial2.println(strb[NewState]);
      Serial.print(strb[NewState]);Serial.print(' ');
      Serial.println(cnt);
      NewStateFlag = 0;
      }
   else {   
      if (Holdstrp) {                 // wenn Stop dann String wiederholen
         Serial2.println(strb[NewState]);
         }         
      else { 
         cnt++;  
         switch (cnt % 10) { 
         case 0: if (cnti==0) {                // Ausgabe nach 10 counts
                    Serial2.println(VERSION);  // jeder 4. Teststring
                    }
                else {               
                    Serial2.println(stra[cnti]);            
                    }
                cnti++; cnti = cnti & 0x03;    // String index
                break;
         case 3:
                //getPowerState();    // Absturz, wenn periodisch
                Serial.println("_3");
                Serial2.print('c');Serial2.println(noticnt);
                //XpressNet.getLocoInfo(3);
                break;
         case 5:
                //getPowerState();    // Absturz, wenn periodisch
                //Serial.print("_5");
                //Serial3.print('c');Serial3.println(noticnt);
                //XpressNet.getLocoInfo(4);
                break;
         
         } // switch()
      } 
    }
   } // if millis
} // Ard2Rasp()


void Ard2Xbus(void) {
aktuellXZeit = millis();
if (aktuellXZeit - davorXZeit > WAIT) {
   davorXZeit = aktuellXZeit;
   if (delcnt) {
       delcnt--;
       Serial.print('-');
       if (delcnt == 0) {
           XBout(QWnum);   // verzögerte Ausgabe der 2. gleichen Adr.
           Serial.print('v');
           }
       }
   else { 
        QWnum = RDqueue();
        if (QWnum) {
            if (abs(QWnum) != lastAdr) {   // Adressen ungleich, Ausgabe   
                XBout(QWnum);   
                Serial.print('.');        
                }  
             else {                       // gleich, 2.Adr mit delay ausgeben     
                  delcnt=3;    
                  }
         }
         else { // keine Schaltaufgabe, Info XBus anfordern
              PScnt--;
              if (PScnt == 0) {
                 PScnt = RQUEST;
                 //getPowerState();
                 }            
              }
      }
   } // millis()  
  
} // Ard2Xbus()


void Rasp2Ard(void) {
if (Serial2.available() > 0)  {   
     y = Serial2.read();     
     sarray[i] = y;                     // char einsammeln
     i++;
     if (i > (ADIM-5)) {
         Serial.println("near overflow, i=0");
         i=0;
         }
     if (y == 0x0A) {           // LF         
        sarray[i]= '\0';         
        switch (sarray[0]) {
         
        case 'b':             
        case 'B':             // LokStop, RmNr und LokAdr.
             Serial.println(sarray);
             parserB(sarray);
             sarray[0] = '\0';
             i=0;
            break;       
        case 'R':             // Arduino Reset vom Rasp. ausloesen
             Serial.print(sarray);             
             sarray[0] = '\0';
             i=0;
             delay(500);
             //-------------------
             resetFunc();
             //getPowerState();
             //Serial3.println(~portsAC);     // Ausgabe RM an Raspberry 
            break; 
        case 'V':             // Void, Lokstop löschen
        case 'D':             // Direction
        case 'L':             // Lok Start
        case 'l':             // Lok Stop
        case 'F':             // Funktionen F0-F4
        case 'f':             // Tunktion Toggle (Horn)
        case 'S':             // Speed
        case 'G':             // Speed bypass (Bremsstufe am Signal n-1)
             //Serial.print(sarray);
             parserL(sarray);
             sarray[0] = '\0';
             i=0;
            break;
             
        default:             
              num = atoi(sarray);    
              Serial.print("R>Adr:");Serial.print(num);
              StartTime = millis();  // Stellbefehl, Empfang
              EWeiche(num);
              sarray[0] = '\0';
              i=0; 
             break;
         } //switch
     } // LF 
  } // if serial avail. 
  
} // Rasp2Ard()

//-------------------------------------------------------------
void loop() {

#ifdef LOCONET
updateLN();
#else
//XpressNet.update(); // mandatory: permanent update the library
XpressNet.receive();  //permernet update the library
#endif

Ard2Rasp();

Ard2Xbus();

Rasp2Ard();
 
} // loop()

// -----------------------------------------------------------------
#ifdef LOCONET
bool checkSlot(word Adr) {
  byte j; // Schleifenzähler
  Serial.println(F("===> checkSlot <==="));
  XL_getLocoInfo(Adr);
  byte Slot = Throttle.getSlot();             // ---> aktuellen Slot holen
  TH_STATE Status = Throttle.getState();      //      aktuellen Slotstatus holen
  word SlotAdr = Throttle.getAddress();       //      aktuelle Lokadresse aus Slot holen und mit gewählter Adresse vergleichen
  if (Adr == SlotAdr) {                       //      gewählte Lokadresse ist im Slot
    if (Status == TH_ST_IN_USE) return true;  // ---> Slot ist bereit, also gib ihm!
    return false;
  }

  // gewählte Lokadresse ist NICHT im Slot
  if (!Adr) return false;                        // ---> ganz haesslich: Weichenbefehl hat Slot geklaut und Lokadresse = 0 gesetzt!
  if (Throttle.getState() >= TH_ST_SLOT_STEAL) { // ---> Slot ist von einer verherigen Lokadresse in Gebrauch
    Fehler = Throttle.dispatchAddress();         //      unpassende Lokadresse freigeben
    for (j = 0; j < 32; j++) {                   //      warten, bis Slot wieder verfügbar
      updateLN(); if (Throttle.getState() <= TH_ST_RELEASE) break;
    }
    Serial.print(F("===> checkSlot: dispatchAddress "));
    XL_getLocoInfo(Adr);
    }
  if(Throttle.getState() <= TH_ST_RELEASE) {     // ---> Lokadresse
    Fehler = Throttle.setAddress(Adr);           //      Slot von Zentrale besorgen
    for (j = 0; j < 32; j++) {                   //      warten, bis Slot bereit
      updateLN(); if (Throttle.getState() == TH_ST_IN_USE) break;
    }
    Serial.print(F("===> checkSlot: setAddress "));
    XL_getLocoInfo(Adr);
    }
  if ((Throttle.getState() == TH_ST_FREE)) {     // ---> Lokadresse liegt auf Regler der Zentrale
    Fehler = Throttle.stealAddress(Adr);         //      Lokadresse "feindlich" übernehmen
    for (j = 0; j < 32; j++) {                   //      warten, bis Slot bereit
      updateLN(); if (Throttle.getState() == TH_ST_IN_USE) break;
    }
    Serial.print(F("===> checkSlot: stealAddress "));
    XL_getLocoInfo(Adr);
  }
  for (j = 0; j < 32; j++) {                   //      warten, bis Slot bereit
    updateLN(); if (Throttle.getState() == TH_ST_IN_USE) break;
  }
  Serial.print(F("===> checkSlot: exit "));
  XL_getLocoInfo(Adr);
  return true;
}
#endif

void XL_setFunc0to4(uint16_t Adr, uint8_t Fu0to4) {
#ifndef LOCONET  
XpressNet.setFunc0to4(Adr, Fu0to4);
#else
TH_ERROR Fehler; byte Dir = Throttle.getDirection();
if (Dir) Fu0to4 = Fu0to4 | DIRF_DIR;
else     Fu0to4 = Fu0to4 & ~DIRF_DIR;
  if (!checkSlot(Adr)) return;
  Fehler = Throttle.setDirFunc0to4Direct(Fu0to4); updateLN();
  Serial.println(); Serial.println(F("===> setFunc0to4 ")); Serial.print(Dir); Serial.print(F(", ")); Serial.print(Fu0to4, HEX); Serial.print(F(" "));
  XL_getLocoInfo(Adr);
#endif
}


// -----------------------------------------------------------------
// Quelle: Xc_03a.ino
void XL_setSpeed(uint16_t Adr, uint8_t Lspst, uint8_t sp) {
#ifndef LOCONET
XpressNet.setLocoDrive(Adr >> 8, Adr & 0x0FF, Lspst-1, sp); // Client: 3=128 steps
//XpressNet.setLocoDrive(Adr >> 8, Adr & 0x0FF, Lspst, sp); // Master: 4=128 steps
#else
TH_ERROR Fehler;
byte  Dir = !(sp & 0x80);
byte  Spd = (sp & 0x7f);
  if (!checkSlot(Adr)) return;
  Fehler = Throttle.setDirection(Dir);
  Fehler = Throttle.setSpeed(Spd); updateLN();
  Serial.println(); Serial.print(F("===> setSpeed ")); Serial.print(Spd); Serial.print(F(" "));
  XL_getLocoInfo(Adr);
#endif
}


#ifdef LOCONET
void LN_printLocoInfo (uint16_t LocoAddr, uint8_t Data) {
//void LN_printLocoInfo (uint16_t LocoAddr, uint8_t Data, TH_ERROR Error) {
  Serial.print ("#### "); Serial.print (Data); Serial.println (" ####");
  Serial.print ("---> LN: LocoAddr "); Serial.print (LocoAddr); Serial.print (", SlotAddr "); Serial.print (Throttle.getAddress ());
  Serial.print (", Slot "); Serial.print (Throttle.getSlot ()); Serial.print (", State "); Serial.println (Throttle.getStateStr (Throttle.getState ()));
//  Serial.print (", Error "); Serial.println (Throttle.getErrorStr (Error));
}
#endif
void XL_getLocoInfo(uint16_t Adr) {    //Slave Modus Lok Informationen erfragen!
#ifndef LOCONET  
//XpressNet.getLocoInfo (Adr >> 8, Adr & 0xFF);
XpressNet.getLocoStateFull(Adr >> 8, Adr & 0xFF,true);
#else
updateLN();
word SlotAdr = Throttle.getAddress(); byte Slot = Throttle.getSlot(); TH_STATE Status = Throttle.getState();
byte Speed = Throttle.getSpeed(); byte Dir = Throttle.getDirection();
Serial.print(F("---> Lokinfo: vorheriger Fehler ")); Serial.println(Fehler);
Serial.print(F("              gewaehlte Adresse ")); Serial.println(Adr);
Serial.print(F("              Slot-Adresse      ")); Serial.println(SlotAdr);
Serial.print(F("              Slot-Nummer       ")); Serial.println(Slot);
Serial.print(F("              Slot-Status       ")); Serial.println(Throttle.getStateStr(Status));
Serial.print(F("              Fahrtrichtung     ")); Serial.println(Dir);
Serial.print(F("              Fahrstufe         ")); Serial.println(Speed);
Serial.print(F("              Funktionen        ")); for (byte i = 0; i < 5; i++) {
  Serial.print(i); Serial.print(F(" = "));
  char Function = Throttle.getFunction(i); if (Function) Function = 'E'; else Function = 'a';
  Serial.print(Function); if (i < 4) Serial.print(F(", "));
}
Serial.println();
FirstSel = false;
#endif
}

// -----------------------------------------------------------------

#ifdef LOCONET
void notifyPower(uint8_t State) {
#else

void notifyXNetPower(uint8_t State) {
#endif
static uint8_t laststate = 0xFF;
#ifdef LOCONET
  switch (State) {
    case 0: case OPC_GPOFF:
      State = 1;
      break;
    case 1: case OPC_GPON:
      State = 0;
      break;
    case OPC_IDLE:
      break;
    case OPC_BUSY:
      break;
    default:
      break;
  }
#endif


if (laststate != State) {
   laststate    = State;
   NewState     = State;
   if (State >= 1) {
      Holdstrp = 1;
      }
   else {
      Holdstrp = 0;
      }
   NewStateFlag = 1;
   }
}

// unklar, nicht brauchbar: z.B. Adr 303: 
// notifyTrnt(): 0 46 2
// notifyTrnt(): 0 47 1

void notifyTrnt(uint8_t Adr_High, uint8_t Adr_Low, uint8_t Pos) {

//uint16_t Adr = (Adr_High << 8) + Adr_Low;
//Serial.print("notifyTrnt(): ");Serial.print(Adr_High);
//Serial.print(' ');Serial.print(Adr_Low);
//Serial.print(' ');Serial.println(Pos);
}
 

void notifyFeedback(uint8_t Adr_High, uint8_t Adr_Low, uint8_t Pos) {
Serial.print("Adr H, L, Pos: "); Serial.print(Adr_High);
Serial.print(" ");Serial.print(Adr_Low);
Serial.print(" ");Serial.println(Pos);  
}


void notifyXNetStatus(uint8_t LedState ) {
  noticnt++;
  if (noticnt >= 100) {
     //Serial.print("notifyTrnt: ");Serial.println(Address); 
     noticnt = 0;
  }
}

//--------------------------------------------------------------
#ifndef LOCONET
void notifyLokAll(uint8_t Adr_High, uint8_t Adr_Low, boolean Busy, uint8_t Steps, uint8_t Speed, \
uint8_t Direction, uint8_t Func1, uint8_t Func2, uint8_t Func3, uint8_t Func4, boolean Req ) {


// Linf[] global
char Linf1[]   = {"  "};
char Linf2[10] = {0};

uint16_t   Adr;
uint8_t    Locoi;

if (Adr_High >= 192) {  // Lange Adr.
    Adr = ((Adr_High - 192) << 8) + Adr_Low;
    }  
else {                  // kurze Adr. wie Xc_01n.ino
    Adr = (Adr_High << 8) + Adr_Low;  
    }

Linf[0] = '*';
itoa(Adr,Linf+1,10);

if (Direction) {
    Linf1[1] = 'V';
    //Direction = 0;
    }
else  {
    Linf1[1] = 'R'; 
    //Direction = 1;
    }

strcat(Linf,Linf1);

Linf2[0] = ' ';
itoa(Func1,Linf2+1,10);
strcat(Linf,Linf2);

Serial.println(Linf);

Locoi = CntLok(Adr);   
Serial.print("Lok:");Serial.print(Adr);Serial.print(" Fgroup0:");Serial.println(Func1);
Larray[Locoi].Fugroup0 = Func1;

} // notifyLokAll()

#endif

// -----------------------------------------------------------
